import { showScreen } from "./main.js";
import { initDB, getDB, ScoreRecord, Scores } from "./db.js";

/**
 * 
 * @param {Array<Scores>} scores 
 */
export function execScore(scores){
    console.log(scores);
    /**
     * 
     * @param {Array<ScoreRecord>} top3 
     */
    function renderScores(top3) {
        console.log(top3);
        const container = document.getElementById("score-list");
        container.innerHTML = ""; // クリア

        top3.forEach((record, i) => {
            const div = document.createElement("div");
            const date = new Date(record.timestamp);

            // 日本標準時で表示
            const jstString = date.toLocaleString("ja-JP", {
                timeZone: "Asia/Tokyo"
            });
            div.textContent = `${i + 1}位: ${record.score}点 - ${jstString}`;
            container.appendChild(div);
        });
    }
    const buttons = document.querySelectorAll("#difficulty-tabs button");
    buttons.forEach(btn => {
        btn.onclick = () => {
            alert("まだこの難易度では挑戦していません。");
        };
    });
    for(const s of scores){
        const btn = document.getElementById(s.difficulty);
        if(btn){
            btn.onclick = () => {
                buttons.forEach(b => b.classList.remove("active"));
                btn.classList.add("active");
                
                renderScores(s.top3);
            }
        }
    }
    document.querySelector("#to-title").onclick = () => {
        showScreen("title");
    }
} 